/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRDimension;
import lotr.common.LOTRLevelData;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class LOTRSpawnDamping {
    public static Map<String, Float> spawnDamping = new HashMap<String, Float>();
    public static String TYPE_NPC = "lotr_npc";
    public static boolean needsSave = true;

    public static int getCreatureSpawnCap(EnumCreatureType type, World world) {
        return LOTRSpawnDamping.getSpawnCap(type.name(), type.func_75601_b(), world);
    }

    public static int getNPCSpawnCap(World world) {
        return LOTRSpawnDamping.getSpawnCap(TYPE_NPC, LOTRDimension.getCurrentDimensionWithFallback((World)world).spawnCap, world);
    }

    public static int getSpawnCap(String type, int baseCap, World world) {
        int players = world.field_73010_i.size();
        return LOTRSpawnDamping.getSpawnCap(type, baseCap, players);
    }

    public static int getSpawnCap(String type, int baseCap, int players) {
        float f;
        float f2;
        float damp = LOTRSpawnDamping.getSpawnDamping(type);
        float dampFraction = (float)(players - 1) * damp;
        dampFraction = MathHelper.func_76131_a((float)dampFraction, (float)0.0f, (float)1.0f);
        float stationaryPointValue = 0.5f + damp / 2.0f;
        if (f2 > f) {
            dampFraction = stationaryPointValue;
        }
        int capPerPlayer = Math.round((float)baseCap * (1.0f - dampFraction));
        capPerPlayer = Math.max(capPerPlayer, 1);
        return capPerPlayer;
    }

    public static float getSpawnDamping(String type) {
        float f = 0.0f;
        if (spawnDamping.containsKey(type)) {
            f = spawnDamping.get(type).floatValue();
        }
        return f;
    }

    public static void setSpawnDamping(EnumCreatureType type, float damping) {
        LOTRSpawnDamping.setSpawnDamping(type.name(), damping);
    }

    public static void setNPCSpawnDamping(float damping) {
        LOTRSpawnDamping.setSpawnDamping(TYPE_NPC, damping);
    }

    public static void setSpawnDamping(String type, float damping) {
        spawnDamping.put(type, Float.valueOf(damping));
        LOTRSpawnDamping.markDirty();
    }

    public static int getBaseSpawnCapForInfo(String type, World world) {
        if (type.equals(TYPE_NPC)) {
            return LOTRDimension.getCurrentDimensionWithFallback((World)world).spawnCap;
        }
        EnumCreatureType creatureType = EnumCreatureType.valueOf((String)type);
        if (creatureType != null) {
            return creatureType.func_75601_b();
        }
        return -1;
    }

    private static void markDirty() {
        needsSave = true;
    }

    private static File getDataFile() {
        return new File(LOTRLevelData.getOrCreateLOTRDir(), "spawn_damping.dat");
    }

    public static void saveAll() {
        try {
            File datFile = LOTRSpawnDamping.getDataFile();
            if (!datFile.exists()) {
                CompressedStreamTools.func_74799_a((NBTTagCompound)new NBTTagCompound(), (OutputStream)new FileOutputStream(datFile));
            }
            NBTTagCompound spawnData = new NBTTagCompound();
            NBTTagList typeTags = new NBTTagList();
            for (Map.Entry<String, Float> e : spawnDamping.entrySet()) {
                String type = e.getKey();
                float damping = e.getValue().floatValue();
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("Type", type);
                nbt.func_74776_a("Damp", damping);
                typeTags.func_74742_a((NBTBase)nbt);
            }
            spawnData.func_74782_a("Damping", (NBTBase)typeTags);
            LOTRLevelData.saveNBTToFile(datFile, spawnData);
            needsSave = false;
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error saving LOTR spawn damping", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void loadAll() {
        try {
            File datFile = LOTRSpawnDamping.getDataFile();
            NBTTagCompound spawnData = LOTRLevelData.loadNBTFromFile(datFile);
            spawnDamping.clear();
            if (spawnData.func_74764_b("Damping")) {
                NBTTagList typeTags = spawnData.func_150295_c("Damping", 10);
                for (int i = 0; i < typeTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = typeTags.func_150305_b(i);
                    String type = nbt.func_74779_i("Type");
                    float damping = nbt.func_74760_g("Damp");
                    if (StringUtils.isBlank((CharSequence)type)) continue;
                    spawnDamping.put(type, Float.valueOf(damping));
                }
            }
            needsSave = true;
            LOTRSpawnDamping.saveAll();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading LOTR spawn damping", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void resetAll() {
        spawnDamping.clear();
        LOTRSpawnDamping.markDirty();
    }
}

